/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.init;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import p455w0rd.danknull.init.ModLogger;
import p455w0rd.danknull.init.ModNetworking;
import p455w0rd.danknull.network.PacketConfigSync;
import p455w0rd.danknull.util.NonNullListSerializable;
import p455w0rd.danknull.util.WeakHashMapSerializable;

public class ModConfig {
    private static Configuration CONFIG = null;
    public static final String SERVER_CAT = "Server Rules";
    public static final boolean DEBUG_RESET = false;
    public static final String NAME_CREATIVE_BLACKLIST = "CreativeBlacklist";
    public static final String NAME_CREATIVE_WHITELIST = "CreativeWhitelist";
    public static final String NAME_OREDICT_BLACKLIST = "OreDictBlacklist";
    public static final String NAME_OREDICT_WHITELIST = "OreDictWhitelist";
    public static final String NAME_DISABLE_OREDICT = "DisableOreDictMode";
    public static final String NAME_ENABLE_COLORED_LIGHTING = "EnableColorShaders";
    public static final String NAME_ALLOW_DOCK_INSERTION = "AllowDockInsertion";
    public static final String NAME_CALL_IT_DEVNULL = "CallItDevNull";
    public static final String NAME_SUPERSHINE = "SuperShine";
    public static final String NAME_ONLY_CYCLE_BLOCKS = "onlyCycleBlocks";
    static boolean init = false;

    private static Configuration config() {
        if (CONFIG == null) {
            CONFIG = new Configuration(new File("config/DankNull.cfg"));
        }
        return CONFIG;
    }

    public static Configuration getInstance() {
        return ModConfig.config();
    }

    public static void load() {
        ModConfig.sync();
    }

    public static void sync() {
        Options.callItDevNull = ModConfig.config().getBoolean(NAME_CALL_IT_DEVNULL, "client", false, "Call it a /dev/null in-game (Requested by TheMattaBase)");
        Options.superShine = ModConfig.config().getBoolean(NAME_SUPERSHINE, "client", false, "Make items ultra shiny!");
        Options.skipNonBlocksOnCycle = ModConfig.config().getBoolean(NAME_ONLY_CYCLE_BLOCKS, "client", false, "When cycling selected item with /dank/null in-hand, should it try to only cycle blocks?");
        Options.creativeBlacklist = ModConfig.config().getString(NAME_CREATIVE_BLACKLIST, SERVER_CAT, "", "A semicolon separated list of items that are not allowed to be placed into the creative /dank/null\nFormat: modid:name:meta (meta optional: modid:name is acceptable) - Example: minecraft:diamond;minecraft:coal:1").trim();
        Options.creativeWhitelist = ModConfig.config().getString(NAME_CREATIVE_WHITELIST, SERVER_CAT, "", "A semicolon separated list of items that are allowed to be placed into the creative /dank/null\nSame format as Blacklist and whitelist superceeds blacklist.\nIf whitelist is non-empty, then ONLY whitelisted items can be added to the Creative /dank/null").trim();
        Options.oreBlacklist = ModConfig.config().getString(NAME_OREDICT_BLACKLIST, SERVER_CAT, "itemSkull", "A semicolon separated list of Ore Dictionary entries (strings) which WILL NOT be allowed to be used with /dank/null's Ore Dictionary functionality.");
        Options.oreWhitelist = ModConfig.config().getString(NAME_OREDICT_WHITELIST, SERVER_CAT, "", "A semicolon separated list of Ore Dictionary entries (strings) which WILL BE allowed to be used with /dank/null's Ore Dictionary functionality. Whitelist superceeds blacklist.\nIf whitelist is non-empty, then ONLY Ore Dictionary items matching the entries will\nbe able to take advantage of /dank/null's Ore Dictionary functionality.");
        Options.disableOreDictMode = ModConfig.config().getBoolean(NAME_DISABLE_OREDICT, SERVER_CAT, false, "If set to true, then Ore Dictionary Mode will not be available (overrides Ore Dictionary White/Black lists)");
        Options.showHUD = ModConfig.config().getBoolean("showHUD", "client", true, "Show the /dank/null HUD overlay?");
        Options.allowDockInserting = ModConfig.config().getBoolean(NAME_ALLOW_DOCK_INSERTION, SERVER_CAT, true, "If true, you will be able to pipe items into the /dank/null Docking Station");
        if (ModConfig.config().hasChanged()) {
            ModConfig.config().save();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static List<IConfigElement> getClientConfigElements() {
        return new ConfigElement(ModConfig.getInstance().getCategory("client")).getChildElements();
    }

    @SideOnly(value=Side.SERVER)
    public static void sendConfigsToClient(EntityPlayerMP player) {
        WeakHashMapSerializable<String, Object> map = new WeakHashMapSerializable<String, Object>();
        map.put(NAME_CREATIVE_BLACKLIST, Options.creativeBlacklist);
        map.put(NAME_CREATIVE_WHITELIST, Options.creativeWhitelist);
        map.put(NAME_OREDICT_BLACKLIST, Options.oreBlacklist);
        map.put(NAME_OREDICT_WHITELIST, Options.oreWhitelist);
        map.put(NAME_DISABLE_OREDICT, Options.disableOreDictMode);
        ModNetworking.getInstance().sendTo((IMessage)new PacketConfigSync(map), player);
    }

    public static boolean isOreDictBlacklistEnabled() {
        return !Options.getOreBlacklist().isEmpty() && !ModConfig.isOreDictWhitelistEnabled();
    }

    public static boolean isOreDictWhitelistEnabled() {
        return !Options.getOreWhitelist().isEmpty();
    }

    public static boolean isOreBlacklisted(String oreName) {
        for (String currentOre : Options.getOreBlacklist()) {
            if (!currentOre.equals(oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOreWhitelisted(String oreName) {
        for (String currentOre : Options.getOreWhitelist()) {
            if (!currentOre.equals(oreName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidOre(String oreName) {
        boolean isValid = true;
        if (ModConfig.isOreConfigEnabled()) {
            boolean bl = isValid = ModConfig.isOreDictWhitelistEnabled() && ModConfig.isOreWhitelisted(oreName);
            if (!isValid) {
                isValid = ModConfig.isOreDictBlacklistEnabled() && !ModConfig.isOreBlacklisted(oreName);
            }
        }
        return isValid;
    }

    public static boolean isOreConfigEnabled() {
        return !Options.disableOreDictMode && ModConfig.isOreDictBlacklistEnabled() || ModConfig.isOreDictWhitelistEnabled();
    }

    public static boolean isItemOreDictBlacklisted(ItemStack stack) {
        if (ModConfig.isOreConfigEnabled() && ModConfig.isOreDictBlacklistEnabled()) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                String currentOreName = OreDictionary.getOreName((int)id);
                if (!ModConfig.isValidOre(currentOreName)) continue;
                for (String oreName : Options.getOreBlacklist()) {
                    if (!ModConfig.isValidOre(oreName) || !oreName.equals(currentOreName)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isItemOreDictWhitelisted(ItemStack stack) {
        if (ModConfig.isOreConfigEnabled() && ModConfig.isOreDictWhitelistEnabled()) {
            for (int id : OreDictionary.getOreIDs((ItemStack)stack)) {
                String currentOreName = OreDictionary.getOreName((int)id);
                if (!ModConfig.isValidOre(currentOreName)) continue;
                for (String oreName : Options.getOreWhitelist()) {
                    if (!ModConfig.isValidOre(oreName) || !oreName.equals(OreDictionary.getOreName((int)id))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static class Options {
        public static boolean callItDevNull = false;
        public static boolean superShine = false;
        public static String creativeBlacklist = "";
        public static String creativeWhitelist = "";
        public static String oreBlacklist = "";
        public static String oreWhitelist = "";
        public static boolean showHUD = true;
        private static NonNullListSerializable<ItemStack> creativeItemBlacklist;
        private static NonNullListSerializable<ItemStack> creativeItemWhitelist;
        private static ArrayList<String> oreStringBlacklist;
        private static ArrayList<String> oreStringWhitelist;
        public static boolean disableOreDictMode;
        public static boolean allowDockInserting;
        public static boolean skipNonBlocksOnCycle;

        public static List<String> getOreBlacklist() {
            String[] tmpList = null;
            if (oreStringBlacklist.isEmpty() && !oreBlacklist.isEmpty() && Options.getOreWhitelist().isEmpty()) {
                tmpList = oreBlacklist.split(";");
            }
            if (tmpList != null) {
                for (String string : tmpList) {
                    if (!OreDictionary.doesOreNameExist((String)string)) continue;
                    oreStringBlacklist.add(string);
                }
            }
            return oreStringBlacklist;
        }

        public static List<String> getOreWhitelist() {
            String[] tmpList = null;
            if (oreStringWhitelist.isEmpty() && !oreWhitelist.isEmpty()) {
                tmpList = oreWhitelist.split(";");
            }
            if (tmpList != null) {
                for (String string : tmpList) {
                    if (!OreDictionary.doesOreNameExist((String)string)) continue;
                    oreStringWhitelist.add(string);
                }
            }
            return oreStringWhitelist;
        }

        public static NonNullListSerializable<ItemStack> getCreativeBlacklistedItems() throws Exception {
            if (creativeItemBlacklist == null && Options.getCreativeWhitelistedItems().isEmpty()) {
                creativeItemBlacklist = (NonNullListSerializable)NonNullListSerializable.func_191196_a();
                if (!creativeBlacklist.isEmpty()) {
                    ArrayList itemStringList = Lists.newArrayList((Object[])creativeBlacklist.split(";"));
                    for (String itemString : itemStringList) {
                        Item item;
                        String[] params = itemString.split(":");
                        int numColons = params.length - 1;
                        if (numColons > 2 || numColons <= 0) {
                            throw new Exception(new Throwable("Invalid format for item blacklisting, check " + ModConfig.config().getConfigFile() + " for an example"));
                        }
                        if (numColons == 1) {
                            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(params[0], params[1]));
                            if (item == null) {
                                ModLogger.warn("Item \"" + params[0] + ":" + params[1] + "\" not found");
                                continue;
                            }
                            creativeItemBlacklist.add(new ItemStack(item));
                            continue;
                        }
                        if (numColons != 2) continue;
                        item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(params[0], params[1]));
                        if (item == null) {
                            ModLogger.warn("Item \"" + params[0] + ":" + params[1] + "\" not found");
                            continue;
                        }
                        int meta = -1;
                        try {
                            meta = Integer.parseInt(params[2]);
                        }
                        catch (NumberFormatException e) {
                            meta = -1;
                        }
                        if (meta < 0) {
                            ModLogger.warn("Invalid metadata for item \"" + params[0] + ":" + params[1] + "\" (" + params[2] + ")");
                            continue;
                        }
                        creativeItemWhitelist.add(new ItemStack(item, 1, meta));
                    }
                }
            }
            return creativeItemBlacklist;
        }

        public static NonNullListSerializable<ItemStack> getCreativeWhitelistedItems() throws Exception {
            if (creativeItemWhitelist == null) {
                creativeItemWhitelist = (NonNullListSerializable)NonNullListSerializable.func_191196_a();
                if (!creativeWhitelist.isEmpty()) {
                    ArrayList itemStringList = Lists.newArrayList((Object[])creativeWhitelist.split(";"));
                    for (String itemString : itemStringList) {
                        Item item;
                        String[] params = itemString.split(":");
                        int numColons = params.length - 1;
                        if (numColons > 2 || numColons <= 0) {
                            throw new Exception(new Throwable("Invalid format for item whitelisting, check " + ModConfig.config().getConfigFile() + " for an example"));
                        }
                        if (numColons == 1) {
                            item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(params[0], params[1]));
                            if (item == null) {
                                ModLogger.warn("Item \"" + params[0] + ":" + params[1] + "\" not found");
                                continue;
                            }
                            creativeItemWhitelist.add(new ItemStack(item));
                            continue;
                        }
                        if (numColons != 2) continue;
                        item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(params[0], params[1]));
                        if (item == null) {
                            ModLogger.warn("Item \"" + params[0] + ":" + params[1] + "\" not found");
                            continue;
                        }
                        int meta = -1;
                        try {
                            meta = Integer.parseInt(params[2]);
                        }
                        catch (NumberFormatException e) {
                            meta = -1;
                        }
                        if (meta < 0) {
                            ModLogger.warn("Invalid metadata for item \"" + params[0] + ":" + params[1] + "\" (" + params[2] + ")");
                            continue;
                        }
                        creativeItemWhitelist.add(new ItemStack(item, 1, meta));
                    }
                }
            }
            return creativeItemWhitelist;
        }

        static {
            oreStringBlacklist = Lists.newArrayList();
            oreStringWhitelist = Lists.newArrayList();
            disableOreDictMode = false;
            allowDockInserting = true;
            skipNonBlocksOnCycle = false;
        }
    }
}

