/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.init;

import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.util.EnumHelper;

public class ModGlobals {
    public static final String MODID_PWLIB = "p455w0rdslib";
    public static final String MODID = "danknull";
    public static final String VERSION = "1.7.91";
    public static final String NAME = "/dank/null";
    public static final String SERVER_PROXY = "p455w0rd.danknull.proxy.CommonProxy";
    public static final String CLIENT_PROXY = "p455w0rd.danknull.proxy.ClientProxy";
    public static final String GUI_FACTORY = "p455w0rd.danknull.init.ModGuiFactory";
    public static final String DEPENDANCIES = "required-after:p455w0rdslib@[2.3.161,);after:stg;after:jei;after:waila;after:theoneprobe;after:nei";
    public static boolean GUI_DANKNULL_ISOPEN = false;
    public static float TIME = 0.0f;

    public static enum DankNullTier {
        REDSTONE,
        LAPIS,
        IRON,
        GOLD,
        DIAMOND,
        EMERALD,
        CREATIVE,
        NONE;

        public static DankNullTier[] VALUES;
        private static final int[] OPAQUE_HEX_COLORS;
        private static final int[] HEX_COLORS;

        public ResourceLocation getDankNullRegistryName() {
            return new ResourceLocation(ModGlobals.MODID, this.getUnlocalizedNameForDankNull());
        }

        public ResourceLocation getDankNullPanelRegistryName() {
            return new ResourceLocation(ModGlobals.MODID, this.getUnlocalizedNameForPanel());
        }

        public String getUnlocalizedNameForDankNull() {
            return "dank_null_" + this.ordinal();
        }

        public String getUnlocalizedNameForPanel() {
            return "dank_null_panel_" + this.ordinal();
        }

        public int getMaxStackSize() {
            int level = this.ordinal() + 1;
            if (level >= 6) {
                return Integer.MAX_VALUE;
            }
            return level * 128 * level;
        }

        public int getNumRows() {
            int numRows = this.ordinal();
            if (this.isCreative()) {
                --numRows;
            }
            return numRows + 1;
        }

        public int getNumRowsMultiplier() {
            return this.getNumRows() - 1;
        }

        public boolean isCreative() {
            return this.ordinal() == 6;
        }

        public int getGuiHeight() {
            return 140 + this.getNumRowsMultiplier() * 20 + this.getNumRowsMultiplier() + 1;
        }

        public ResourceLocation getGuiBackground() {
            return new ResourceLocation(ModGlobals.MODID, "textures/gui/danknullscreen" + (this.getNumRowsMultiplier() + (this.isCreative() ? 1 : 0)) + ".png");
        }

        public EnumRarity getRarity() {
            return Rarities.getRarityFromMeta(this.ordinal());
        }

        public int getHexColor(boolean opaque) {
            return opaque ? OPAQUE_HEX_COLORS[this.ordinal()] : HEX_COLORS[this.ordinal()];
        }

        public ItemStack getUpgradedVersion(ItemStack dankNull) {
            String[] id;
            NBTTagCompound raw;
            if (this.ordinal() < 6 && (raw = dankNull.serializeNBT()).func_150297_b("id", 8) && (id = raw.func_74779_i("id").split(":")).length > 0 && id[1].startsWith("dank_null_")) {
                raw.func_74778_a("id", id[0] + ":dank_null_" + (this.ordinal() + 1));
                return new ItemStack(raw);
            }
            return dankNull.func_77946_l();
        }

        static {
            VALUES = DankNullTier.values();
            OPAQUE_HEX_COLORS = new int[]{-1292216, -12024340, -1, -256, -16711681, -15204499, -7399980, 0};
            HEX_COLORS = new int[]{-1712568248, -1723300372, -1711276033, -1711276288, -1727987713, -1726480531, -1718676012, 0};
        }
    }

    public static class NBT {
        public static final String ID = "id";
        public static final String DAMAGE = "Damage";
        public static final String BLOCKENTITYTAG = "BlockEntityTag";
        public static final String SLOT = "Slot";
        public static final String DANKNULL_INVENTORY = "danknull-inventory";
        public static final String DOCKEDSTACK = "DankNullStack";
        public static final String MODE = "Mode";
        public static final String STACK = "Stack";
        public static final String OREDICT = "OreDict";
        public static final String SELECTEDINDEX = "selectedIndex";
        public static final String REALCOUNT = "RealCount";
        public static final String UUID = "UUID";
        public static final String EXTRACTION_MODES = "ExtractionModes";
        public static final String PLACEMENT_MODES = "PlacementModes";
        public static final String OREDICT_MODES = "OreDictModes";
        public static final String LOCKED = "Locked";
    }

    public static class Textures {
        public static final ResourceLocation DOCK_TEXTURE = new ResourceLocation("danknull", "textures/models/danknull_dock.png");
    }

    public static class Rarities {
        private static final EnumRarity[] RARITY_CACHE = new EnumRarity[]{Rarities.createRarity("dn:redstone", TextFormatting.RED), Rarities.createRarity("dn:lapis", TextFormatting.BLUE), Rarities.createRarity("dn:iron", TextFormatting.WHITE), Rarities.createRarity("dn:gold", TextFormatting.YELLOW), Rarities.createRarity("dn:diamond", TextFormatting.AQUA), Rarities.createRarity("dn:emerald", TextFormatting.GREEN), Rarities.createRarity("dn:creative", TextFormatting.LIGHT_PURPLE)};

        public static EnumRarity getRarityFromMeta(int meta) {
            return RARITY_CACHE[meta];
        }

        private static EnumRarity createRarity(String name, TextFormatting color) {
            return EnumHelper.addRarity((String)name, (TextFormatting)color, (String)name);
        }
    }
}

