/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.inventory.cap;

import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import p455w0rd.danknull.api.DankNullItemModes;
import p455w0rd.danknull.api.IDankNullHandler;
import p455w0rd.danknull.inventory.DankNullHandler;
import p455w0rdslib.util.ItemUtils;

public class CapabilityDankNull {
    @CapabilityInject(value=IDankNullHandler.class)
    public static Capability<IDankNullHandler> DANK_NULL_CAPABILITY = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IDankNullHandler.class, (Capability.IStorage)new Capability.IStorage<IDankNullHandler>(){

            public NBTBase writeNBT(Capability<IDankNullHandler> capability, IDankNullHandler instance, EnumFacing side) {
                NBTTagCompound tag = new NBTTagCompound();
                NBTTagList items = new NBTTagList();
                for (int i = 0; i < instance.getSlots(); ++i) {
                    ItemStack stack2 = instance.getFullStackInSlot(i);
                    if (stack2.func_190926_b()) continue;
                    NBTTagCompound item = new NBTTagCompound();
                    stack2.func_77955_b(item);
                    item.func_74768_a("Slot", i);
                    item.func_74768_a("Count", stack2.func_190916_E());
                    items.func_74742_a((NBTBase)item);
                }
                NBTTagList ores = new NBTTagList();
                instance.getOres().forEach((stack, ore) -> {
                    NBTTagCompound oreTag = new NBTTagCompound();
                    oreTag.func_74757_a("OreDict", ore.booleanValue());
                    oreTag.func_74782_a("Stack", (NBTBase)stack.serializeNBT());
                    ores.func_74742_a((NBTBase)oreTag);
                });
                NBTTagList extractionModes = new NBTTagList();
                instance.getExtractionModes().forEach((stack, mode) -> {
                    NBTTagCompound extractionTag = new NBTTagCompound();
                    extractionTag.func_74768_a("Mode", mode.ordinal());
                    extractionTag.func_74782_a("Stack", (NBTBase)stack.serializeNBT());
                    extractionModes.func_74742_a((NBTBase)extractionTag);
                });
                NBTTagList placementModes = new NBTTagList();
                instance.getPlacementMode().forEach((stack, mode) -> {
                    NBTTagCompound placementTag = new NBTTagCompound();
                    placementTag.func_74768_a("Mode", mode.ordinal());
                    placementTag.func_74782_a("Stack", (NBTBase)stack.serializeNBT());
                    placementModes.func_74742_a((NBTBase)placementTag);
                });
                if (!items.func_82582_d()) {
                    tag.func_74782_a("danknull-inventory", (NBTBase)items);
                }
                if (!ores.func_82582_d()) {
                    tag.func_74782_a("OreDictModes", (NBTBase)ores);
                }
                if (!extractionModes.func_82582_d()) {
                    tag.func_74782_a("ExtractionModes", (NBTBase)extractionModes);
                }
                if (!placementModes.func_82582_d()) {
                    tag.func_74782_a("PlacementModes", (NBTBase)placementModes);
                }
                if (instance.getSelected() > -1) {
                    tag.func_74768_a("selectedIndex", instance.getSelected());
                }
                if (instance.isLocked()) {
                    tag.func_74757_a("Locked", instance.isLocked());
                }
                return tag;
            }

            public void readNBT(Capability<IDankNullHandler> capability, IDankNullHandler instance, EnumFacing side, NBTBase base) {
                if (instance instanceof DankNullHandler) {
                    boolean foundStack;
                    NBTTagCompound item;
                    int i;
                    NBTTagList items;
                    DankNullHandler handler = (DankNullHandler)instance;
                    NBTTagCompound tag = (NBTTagCompound)base;
                    if (tag == null || tag.func_82582_d()) {
                        return;
                    }
                    if (tag.func_74764_b("danknull-inventory")) {
                        items = tag.func_150295_c("danknull-inventory", 10);
                        for (i = 0; i < items.func_74745_c(); ++i) {
                            item = items.func_150305_b(i);
                            int slot = item.func_74762_e("Slot");
                            int count = item.func_74762_e("Count");
                            ItemStack stack = new ItemStack(item);
                            stack.func_190920_e(count);
                            instance.validateSlot(slot);
                            instance.getStackList().set(slot, (Object)stack);
                        }
                    }
                    if (tag.func_74764_b("OreDictModes")) {
                        items = tag.func_150295_c("OreDictModes", 10);
                        for (i = 0; i < items.func_74745_c(); ++i) {
                            item = items.func_150305_b(i);
                            boolean oreDict = item.func_74767_n("OreDict");
                            ItemStack stack = new ItemStack(item.func_74775_l("Stack"));
                            if (stack.func_190926_b()) continue;
                            Map<ItemStack, Boolean> oreStacks = instance.getOres();
                            foundStack = false;
                            for (ItemStack currentStack : oreStacks.keySet()) {
                                if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)stack)) continue;
                                oreStacks.put(currentStack, oreDict);
                                foundStack = true;
                                break;
                            }
                            if (foundStack) continue;
                            stack = stack.func_77946_l();
                            stack.func_190920_e(1);
                            oreStacks.put(stack, oreDict);
                        }
                    }
                    if (tag.func_74764_b("ExtractionModes")) {
                        items = tag.func_150295_c("ExtractionModes", 10);
                        for (i = 0; i < items.func_74745_c(); ++i) {
                            item = items.func_150305_b(i);
                            DankNullItemModes.ItemExtractionMode mode = DankNullItemModes.ItemExtractionMode.VALUES[item.func_74762_e("Mode")];
                            ItemStack stack = new ItemStack(item.func_74775_l("Stack"));
                            if (stack.func_190926_b()) continue;
                            Map<ItemStack, DankNullItemModes.ItemExtractionMode> extractionStacks = instance.getExtractionModes();
                            foundStack = false;
                            for (ItemStack currentStack : extractionStacks.keySet()) {
                                if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)stack)) continue;
                                extractionStacks.put(currentStack, mode);
                                foundStack = true;
                                return;
                            }
                            if (foundStack) continue;
                            stack = stack.func_77946_l();
                            stack.func_190920_e(1);
                            extractionStacks.put(stack, mode);
                        }
                    }
                    if (tag.func_74764_b("PlacementModes")) {
                        items = tag.func_150295_c("PlacementModes", 10);
                        for (i = 0; i < items.func_74745_c(); ++i) {
                            item = items.func_150305_b(i);
                            DankNullItemModes.ItemPlacementMode mode = DankNullItemModes.ItemPlacementMode.VALUES[item.func_74762_e("Mode")];
                            ItemStack stack = new ItemStack(item.func_74775_l("Stack"));
                            if (stack.func_190926_b()) continue;
                            Map<ItemStack, DankNullItemModes.ItemPlacementMode> placementStacks = instance.getPlacementMode();
                            for (ItemStack currentStack : placementStacks.keySet()) {
                                if (!ItemUtils.areItemStacksEqualIgnoreSize((ItemStack)currentStack, (ItemStack)stack)) continue;
                                placementStacks.put(currentStack, mode);
                                return;
                            }
                            stack = stack.func_77946_l();
                            stack.func_190920_e(1);
                            placementStacks.put(stack, mode);
                        }
                    }
                    if (tag.func_74764_b("selectedIndex")) {
                        handler.selected = tag.func_74762_e("selectedIndex");
                    }
                    if (tag.func_74764_b("Locked")) {
                        handler.isLocked = tag.func_74767_n("Locked");
                    }
                }
            }
        }, () -> null);
    }
}

